<?php
/* --------------------------------------------------------------
   UserConfiguration.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration\Model;

use Gambio\Admin\UserConfiguration\Interfaces\UserConfiguration as UserConfigurationInterface;
use Gambio\Admin\UserConfiguration\Interfaces\UserConfigurationKey;

/**
 * Class UserConfiguration
 *
 * @package Gambio\Admin\UserConfiguration\Model
 */
class UserConfiguration implements UserConfigurationInterface
{
    /**
     * @var UserConfigurationKey
     */
    private $key;
    
    /**
     * @var string
     */
    private $value;
    
    
    /**
     * UserConfiguration constructor.
     *
     * @param UserConfigurationKey $key
     * @param string               $value
     */
    private function __construct(UserConfigurationKey $key, string $value)
    {
        $this->key   = $key;
        $this->value = $value;
    }
    
    
    /**
     * @param UserConfigurationKey $key
     * @param string               $value
     *
     * @return UserConfiguration
     */
    public static function create(UserConfigurationKey $key, string $value): UserConfiguration
    {
        return new self($key, $value);
    }
    
    
    /**
     * @inheritDoc
     */
    public function key(): string
    {
        return $this->key->value();
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): string
    {
        return $this->value;
    }
}